
**************************************************
CPS 68-72 ICPSR Poverty Clean Program
Program 4 out of 4

8/9/2011: ADDED SORT BY COUNTER TO BE CONSISTENT WITH SORT BY PPOS IN LATER
		  YEARS.  IT DID NOT AFFECT ANY OBS.

5/4/11: ADDED TOT_TRANS AND SSINC AND CACLUALTE AT FAMILY LEVEL

5/3/10:  EDITED TO RUN ON JIM'S COMPUTER
**************************************************;

*********************************************************************
8/22/07: I converted this to a macro and added the tax variables.

THESE NOTES WERE IN THE PROGRAM, BUT FOR SOME REASONS, THIS SCREWS UP
THE MACRO, SO I'VE MOVED THEM TO THE TOP
*never married, divorced, separated, or widowed 
*at least one own never-married kid under 18 
*primary families or unrelated subfamilies 
* For survey years 1972-1975 there's no fkind variable, so create hwfam
*msupwgt is wrong becasue does not include negatives
*get identifiers for primary families without other adults or other families
*going to give the sm status of the primary family to the related subfamily for all sm to match
broader CE definition
* exclude the related subfamilies because their values of the following are 
  already included in the values for the primary family

* 05/11/09 - RA Tom Murray added Povcut Rates in addition to original 
poverty_clean72_75.sas program
**********************************************************************;

options obs=max;

%macro clean6872(yr);

data poverty&yr;
   set cpsdata.cps&yr;
   by famid;

RETAIN counter 0; 
counter= counter+1;
IF FIRST.famid THEN DO; 
   counter=1;
END;

id=famid*100+counter;

IF 2 LE wkswrk LE 7 THEN emp=1;
  ELSE emp=0; 
kid=(age LE 17);

run;

PROC SORT DATA=taxsim.taxs&yr;
   BY id;
RUN;
DATA poverty&yr;
MERGE poverty&yr(IN=in1) taxsim.taxs&yr(DROP=year RENAME=(fica=ts_fica));
BY id;
IF in1;

 ts_tottax=ftl+taxs+(ts_fica/2);
 tot_trans=ssinc+welfinc+uiinc;

run;

proc means sum noprint data=poverty&yr;
   by famid;
   var ts_tottax emp kid tot_trans ssinc;
   output out=tmp1(drop= _type_ _freq_) sum=ftax_nonprime no_earnr_nonprime no_kids_nonprime ftot_trans_nonprime fssinc_nonprime;
run;
*We do this in order to not count head of families who are under 17 as a child;
proc means sum noprint data=poverty&yr;
   by famid;
   var  kid;
   where ftype IN(5,6,7) OR head NE 1;
   output out=tmp_1(drop= _type_ _freq_) sum=no_kids_nonprime_1;
run;
DATA poverty&yr;
MERGE poverty&yr(IN=in1) tmp1(KEEP=famid ftax_nonprime no_earnr_nonprime no_kids_nonprime ftot_trans_nonprime fssinc_nonprime) 
						 tmp_1(KEEP=famid no_kids_nonprime_1);
BY famid;
IF in1;
run;

PROC SORT DATA=poverty&yr;
   BY hhid;
RUN;
proc means sum noprint data=poverty&yr;
   by hhid;
   where ftype in (2,4);
   var ts_tottax emp kid tot_trans ssinc;
   output out=tmp2(drop= _type_ _freq_) sum=ftax_prime no_earnr_prime no_kids_prime ftot_trans_prime fssinc_prime;
run;
*We do this in order to not count head of families who are under 17 as a child;
proc means sum noprint data=poverty&yr;
   by hhid;
   where ftype in (2,4) and head NE 1;
   var  kid;
   output out=tmp_2(drop= _type_ _freq_) sum= no_kids_prime_1;
run;
proc means sum noprint data=poverty&yr;
   by hhid;
   var ts_tottax tot_trans ssinc;
   output out=tmp3(drop= _type_ _freq_) sum=hts_tottax htot_trans hssinc_rr;
run;

DATA poverty&yr;
MERGE poverty&yr(IN=in1) tmp2(KEEP=hhid ftax_prime no_earnr_prime no_kids_prime ftot_trans_prime fssinc_prime) 
					     tmp3(KEEP=hhid hts_tottax htot_trans hssinc_rr) tmp_2(KEEP=hhid no_kids_prime_1);
BY hhid;
IF in1;

IF ftype IN(2,4) THEN fts_tottax=ftax_prime;
   ELSE fts_tottax=ftax_nonprime;
IF ftype IN(2,4) THEN tot_earnrs=no_earnr_prime;
   ELSE tot_earnrs=no_earnr_nonprime;
IF ftype IN(2,4) THEN tot_kids=no_kids_prime;
   ELSE tot_kids=no_kids_nonprime;
IF ftype IN(2,4) THEN tot_kids_1=no_kids_prime_1;
   ELSE tot_kids_1=no_kids_nonprime_1;
IF ftype IN(2,4) THEN ftot_trans_final=ftot_trans_prime;
   ELSE ftot_trans_final=ftot_trans_nonprime;
IF ftype IN(2,4) THEN fssinc_rr_final=fssinc_prime;
   ELSE fssinc_rr_final=fssinc_nonprime;


run;

data temp0;
      set poverty&yr; 
if ftype in (2,4);
run;

proc sort data=temp0;
by famid;
run;

data temp0;
set temp0;
by famid;
retain ftotval2 fpovcut2 ftotearn2 fpersons2 frelu182;
if first.famid and ftype=2 then do;
ftotval2=ftotval;
fpovcut2=fpovcut;
ftotearn2= ftotearn;
fpersons2=fpersons;
frelu182=frelu18;

end;
if last.famid and ftype=4 then output;
run;

PROC SORT DATA=poverty&yr;
   BY famid counter;
RUN;

data temp;
   set poverty&yr;
   by famid counter;
   if first.famid; 

   IF marstat IN (1,3,6,7) AND fownu18 GT 0 AND ftype IN (1,2,4) 
      and sex=2 and 18 LE age LE 54 then sm_f=1;
      ELSE sm_f=0;

   if marstat=2 AND fpersons>1 THEN hwfam=1;
   ELSE hwfam=0;

IF 2 LE wkswrk LE 7 THEN emp_hd_nprime=1;
  ELSE emp_hd_nprime=0; 

  IF age LE 64 AND tot_kids_1 GT 0 AND marstat IN (0,1,3,6,7) THEN dem_grp_nprime=1;
   ELSE IF age LE 64 AND tot_kids_1 GT 0 AND marstat IN (2,4,5) THEN dem_grp_nprime=2;
   ELSE IF age LE 64 AND tot_kids_1=0 AND marstat IN (0,1,3,6,7) THEN dem_grp_nprime=3;
   ELSE IF age LE 64 AND tot_kids_1=0 AND marstat IN (2,4,5) THEN dem_grp_nprime=4;
   ELSE IF age GE 65 THEN dem_grp_nprime=5;

   IF hga LE 12 OR (hga=13 AND hgc NE 1) THEN ed_hd_nprime=1;
      ELSe IF hga=13 AND hgc=1 THEN ed_hd_nprime=2;
      ELSE IF 14 LE hga LE 16 OR (hga=17 AND hgc NE 1) THEN ed_hd_nprime=3;
      ELSE IF hga GT 17 OR (hga=17 AND hgc=1) THEN ed_hd_nprime=4;

run;


data poverty&yr;
merge poverty&yr temp(keep=famid sm_f hwfam emp_hd_nprime dem_grp_nprime ed_hd_nprime) 
			  temp0(keep=famid ftotval2 fpovcut2 ftotearn2 fpersons2 frelu182);
by famid;
if ftype=4 then ftotval_final=ftotval2;
else ftotval_final=ftotval;
if ftype=4 then fpovcut_final=fpovcut2;
else fpovcut_final=fpovcut;
if ftype=4 then ftotearn_final=ftotearn2;
else ftotearn_final=ftotearn;
if ftype=4 then fpersons_final=fpersons2;
else fpersons_final=fpersons;
if ftype=4 then frelu18_final=frelu182;
else frelu18_final=frelu18;

msupwgt=msupwgt3;
run;

proc sort data=poverty&yr;
   by hhid famid counter;
run;

proc means max noprint data=poverty&yr;
by hhid;
var famrel2;
   output out=temp3 max=fammax;
run;

data temp2;
   set temp(rename=(sm_f=sm_h));
   IF ftype IN(1,2);
   keep hhid sm_h;
run;

proc sort data=temp;
by hhid;
run;

proc means sum noprint data=temp;
   by hhid;
   where ftype NE 4;
   var ftotearn fpersons frelu18;
   output out=temp1(drop= _type_ _freq_) sum=htotearn hpersons hrelu18;
run;

data temp4;
   set poverty&yr;
   by hhid famid counter;
   if first.hhid; 

IF 2 LE wkswrk LE 7 THEN emp_hd_prime=1;
  ELSE emp_hd_prime=0; 

  IF age LE 64 AND tot_kids_1 GT 0 AND marstat IN (0,1,3,6,7) THEN dem_grp_prime=1;
   ELSE IF age LE 64 AND tot_kids_1 GT 0 AND marstat IN (2,4,5) THEN dem_grp_prime=2;
   ELSE IF age LE 64 AND tot_kids_1=0 AND marstat IN (0,1,3,6,7) THEN dem_grp_prime=3;
   ELSE IF age LE 64 AND tot_kids_1=0 AND marstat IN (2,4,5) THEN dem_grp_prime=4;
   ELSE IF age GE 65 THEN dem_grp_prime=5;

   IF hga LE 12 OR (hga=13 AND hgc NE 1) THEN ed_hd_prime=1;
      ELSe IF hga=13 AND hgc=1 THEN ed_hd_prime=2;
      ELSE IF 14 LE hga LE 16 OR (hga=17 AND hgc NE 1) THEN ed_hd_prime=3;
      ELSE IF hga GT 17 OR (hga=17 AND hgc=1) THEN ed_hd_prime=4;

KEEP hhid emp_hd_prime dem_grp_prime ed_hd_prime;
run;

proc sort data=temp2;
by hhid;
run;

data cpsdata.poverty&yr;
   merge poverty&yr temp1(keep=hhid htotearn hpersons hrelu18) 
				 temp2(keep=hhid sm_h) 
				 temp3(keep=hhid fammax)
				 temp4(keep=hhid emp_hd_prime dem_grp_prime ed_hd_prime);
   by hhid;
   IF ftype ne 4 then sm=sm_f;
   ELSE IF ftype=4 then sm=sm_h;

   IF ftype=1 and sm=1 and fammax LE 9 then smlone=1;
   ELSE smlone=0;

   IF 1 LE state2 LE 31 THEN hreg=1;
      ELSE IF 32 LE state2 LE 49 THEN hreg=2;
	  ELSE IF 51 LE state2 LE 79 THEN hreg=3;
	  ELSE IF state2 GE 80 THEN hreg=4;


IF ftype IN(2,4) THEN DO;
	dem_grp=dem_grp_prime;
	ed_head=ed_hd_prime;
	emp_head=emp_hd_prime;
END;
IF ftype IN(1,3,5,6,7,8,9) THEN DO;
	dem_grp=dem_grp_nprime;
	ed_head=ed_hd_nprime;
	emp_head=emp_hd_nprime;
END;

run;

proc means;
run;


%mend;

%clean6872(1968);
%clean6872(1969);
%clean6872(1970);
%clean6872(1971);
*%clean6872(1972);



proc sort data=cpsdata.poverty1968;
by hhid famid counter;
run;
proc sort data=cpsdata.poverty1968_bak;
by hhid famid counter;
run;


proc compare base=cpsdata.poverty1968
             compare=cpsdata.poverty1968_bak
			 novalues
;
run;


******************************************************************************
MACRO TO CREATE POVERTY CUTOFFS, POVERTY RATES, POPULATION ESTIMATES, 
AND ESTIMATES ON THE NUMBER OF POOR INDIVIDUALS FOR DIFFERENT SEGMENTS 
OF THE POPULATION. NOTE - WE CAN NOT DETERMINE WITH ACCURACY WHETHER 
A FAMILY RESIDES IN A RESIDENCE THAT CAN BE CLASSIFIED AS FARM/NONFARM
SINCE ALL POVERTY THRESHOLDS BEFORE 1980 MAKE THE DISTINCTION OF 
FARM/NONFARM IN THERE THRESHOLD MEASURES WE TAKE THRESHOLDS BEGINNING IN 1980
AND DEFLATE THEM TO THE SPECIFIED REFERENCE YEAR BECAUSE THE THRESHOLD IN 1980
IS THE FIRST THRESHOLD THAT DOES NOT DIFFERENTIATE BETWEEN FARM/NONFARM
IN THE ASSIGNMENT OF POVERTY THRESHOLDS
******************************************************************************;
%macro poverty6872(yr);
data cpsdata.poverty&yr;
set cpsdata.poverty&yr;
if tot_kids_1=. then tot_kids_1=0;

*Use 1969 Poverty Thresholds and deflate using CPI-U to 1967 levels (survey year 1968);
if &yr=1968 then do; 
if  hdsex=1  and hdage LE 64 and fpersons_final=1 then povcut=1975*0.921348315;
else if  hdsex=1  and hdage GE 65 and fpersons_final=1 then povcut=1774*0.921348315;
else if  hdsex=1  and hdage LE 64 and fpersons_final=2 and tot_kids_1=0 then povcut=2469*0.921348315;
else if  hdsex=1  and hdage LE 64 and fpersons_final=2 and tot_kids_1=1 then povcut=2766*0.921348315;
else if  hdsex=1  and hdage GE 65 and fpersons_final=2 and tot_kids_1=0 then povcut=2216*0.921348315;
else if  hdsex=1  and hdage GE 65 and fpersons_final=2 and tot_kids_1=1 then povcut=2766*0.921348315;
else if  hdsex=1  and fpersons_final=3 and tot_kids_1=0 then povcut=2875*0.921348315;
else if  hdsex=1  and fpersons_final=3 and tot_kids_1=1 then povcut=2968*0.921348315;
else if  hdsex=1  and fpersons_final=3 and tot_kids_1=2 then povcut=3137*0.921348315;
else if  hdsex=1  and fpersons_final=4 and tot_kids_1=0 then povcut=3790*0.921348315;
else if  hdsex=1  and fpersons_final=4 and tot_kids_1=1 then povcut=3847*0.921348315;
else if  hdsex=1  and fpersons_final=4 and tot_kids_1=2 then povcut=3715*0.921348315;
else if  hdsex=1  and fpersons_final=4 and tot_kids_1=3 then povcut=3902*0.921348315;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=0 then povcut=4574*0.921348315;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=1 then povcut=4630*0.921348315;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=2 then povcut=4481*0.921348315;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=3 then povcut=4368*0.921348315;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=4 then povcut=4462*0.921348315;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=0 then povcut=5247*0.921348315;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=1 then povcut=5265*0.921348315;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=2 then povcut=5153*0.921348315;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=3 then povcut=5041*0.921348315;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=4 then povcut=4891*0.921348315;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=5 then povcut=4967*0.921348315;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=0 then povcut=6609*0.921348315;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=1 then povcut=6665*0.921348315;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=2 then povcut=6535*0.921348315;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=3 then povcut=6422*0.921348315;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=4 then povcut=6274*0.921348315;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=5 then povcut=6049*0.921348315;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1 GE 6 then povcut=5994*0.921348315;


*Female non-farm;

else if  hdsex=2  and hdage LE 64 and fpersons_final=1 then povcut=1826*0.921348315;
else if  hdsex=2  and hdage GE 65 and fpersons_final=1 then povcut=1752*0.921348315;
else if  hdsex=2  and hdage LE 64 and fpersons_final=2 and tot_kids_1=0 then povcut=2282*0.921348315;
else if  hdsex=2  and hdage LE 64 and fpersons_final=2 and tot_kids_1=1 then povcut=2491*0.921348315;
else if  hdsex=2  and hdage GE 65 and fpersons_final=2 and tot_kids_1=0 then povcut=2190*0.921348315;
else if  hdsex=2  and hdage GE 65 and fpersons_final=2 and tot_kids_1=1 then povcut=2491*0.921348315;
else if  hdsex=2  and fpersons_final=3 and tot_kids_1=0 then povcut=2781*0.921348315;
else if  hdsex=2  and fpersons_final=3 and tot_kids_1=1 then povcut=2651*0.921348315;
else if  hdsex=2  and fpersons_final=3 and tot_kids_1=2 then povcut=2931*0.921348315;
else if  hdsex=2  and fpersons_final=4 and tot_kids_1=0 then povcut=3641*0.921348315;
else if  hdsex=2  and fpersons_final=4 and tot_kids_1=1 then povcut=3771*0.921348315;
else if  hdsex=2  and fpersons_final=4 and tot_kids_1=2 then povcut=3753*0.921348315;
else if  hdsex=2  and fpersons_final=4 and tot_kids_1=3 then povcut=3715*0.921348315;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=0 then povcut=4368*0.921348315;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=1 then povcut=4500*0.921348315;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=2 then povcut=4481*0.921348315;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=3 then povcut=4444*0.921348315;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=4 then povcut=4294*0.921348315;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=0 then povcut=5096*0.921348315;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=1 then povcut=5191*0.921348315;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=2 then povcut=5153*0.921348315;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=3 then povcut=5115*0.921348315;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=4 then povcut=4948*0.921348315;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=5 then povcut=4798*0.921348315;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=0 then povcut=6403*0.921348315;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=1 then povcut=6497*0.921348315;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=2 then povcut=6478*0.921348315;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=3 then povcut=6422*0.921348315;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=4 then povcut=6255*0.921348315;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=5 then povcut=6124*0.921348315;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1 GE 6 then povcut=5825*0.921348315;
end;

*Use 1969 Poverty Thresholds and deflate using CPI-U to 1968 levels (survey year 1969);
if &yr=1969 then do; 
if  hdsex=1  and hdage LE 64 and fpersons_final=1 then povcut=1975*0.948228883;
else if  hdsex=1  and hdage GE 65 and fpersons_final=1 then povcut=1774*0.948228883;
else if  hdsex=1  and hdage LE 64 and fpersons_final=2 and tot_kids_1=0 then povcut=2469*0.948228883;
else if  hdsex=1  and hdage LE 64 and fpersons_final=2 and tot_kids_1=1 then povcut=2766*0.948228883;
else if  hdsex=1  and hdage GE 65 and fpersons_final=2 and tot_kids_1=0 then povcut=2216*0.948228883;
else if  hdsex=1  and hdage GE 65 and fpersons_final=2 and tot_kids_1=1 then povcut=2766*0.948228883;
else if  hdsex=1  and fpersons_final=3 and tot_kids_1=0 then povcut=2875*0.948228883;
else if  hdsex=1  and fpersons_final=3 and tot_kids_1=1 then povcut=2968*0.948228883;
else if  hdsex=1  and fpersons_final=3 and tot_kids_1=2 then povcut=3137*0.948228883;
else if  hdsex=1  and fpersons_final=4 and tot_kids_1=0 then povcut=3790*0.948228883;
else if  hdsex=1  and fpersons_final=4 and tot_kids_1=1 then povcut=3847*0.948228883;
else if  hdsex=1  and fpersons_final=4 and tot_kids_1=2 then povcut=3715*0.948228883;
else if  hdsex=1  and fpersons_final=4 and tot_kids_1=3 then povcut=3902*0.948228883;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=0 then povcut=4574*0.948228883;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=1 then povcut=4630*0.948228883;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=2 then povcut=4481*0.948228883;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=3 then povcut=4368*0.948228883;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=4 then povcut=4462*0.948228883;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=0 then povcut=5247*0.948228883;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=1 then povcut=5265*0.948228883;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=2 then povcut=5153*0.948228883;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=3 then povcut=5041*0.948228883;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=4 then povcut=4891*0.948228883;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=5 then povcut=4967*0.948228883;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=0 then povcut=6609*0.948228883;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=1 then povcut=6665*0.948228883;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=2 then povcut=6535*0.948228883;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=3 then povcut=6422*0.948228883;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=4 then povcut=6274*0.948228883;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=5 then povcut=6049*0.948228883;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1 GE 6 then povcut=5994*0.948228883;


*Female non-farm;

else if  hdsex=2  and hdage LE 64 and fpersons_final=1 then povcut=1826*0.948228883;
else if  hdsex=2  and hdage GE 65 and fpersons_final=1 then povcut=1752*0.948228883;
else if  hdsex=2  and hdage LE 64 and fpersons_final=2 and tot_kids_1=0 then povcut=2282*0.948228883;
else if  hdsex=2  and hdage LE 64 and fpersons_final=2 and tot_kids_1=1 then povcut=2491*0.948228883;
else if  hdsex=2  and hdage GE 65 and fpersons_final=2 and tot_kids_1=0 then povcut=2190*0.948228883;
else if  hdsex=2  and hdage GE 65 and fpersons_final=2 and tot_kids_1=1 then povcut=2491*0.948228883;
else if  hdsex=2  and fpersons_final=3 and tot_kids_1=0 then povcut=2781*0.948228883;
else if  hdsex=2  and fpersons_final=3 and tot_kids_1=1 then povcut=2651*0.948228883;
else if  hdsex=2  and fpersons_final=3 and tot_kids_1=2 then povcut=2931*0.948228883;
else if  hdsex=2  and fpersons_final=4 and tot_kids_1=0 then povcut=3641*0.948228883;
else if  hdsex=2  and fpersons_final=4 and tot_kids_1=1 then povcut=3771*0.948228883;
else if  hdsex=2  and fpersons_final=4 and tot_kids_1=2 then povcut=3753*0.948228883;
else if  hdsex=2  and fpersons_final=4 and tot_kids_1=3 then povcut=3715*0.948228883;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=0 then povcut=4368*0.948228883;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=1 then povcut=4500*0.948228883;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=2 then povcut=4481*0.948228883;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=3 then povcut=4444*0.948228883;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=4 then povcut=4294*0.948228883;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=0 then povcut=5096*0.948228883;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=1 then povcut=5191*0.948228883;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=2 then povcut=5153*0.948228883;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=3 then povcut=5115*0.948228883;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=4 then povcut=4948*0.948228883;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=5 then povcut=4798*0.948228883;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=0 then povcut=6403*0.948228883;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=1 then povcut=6497*0.948228883;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=2 then povcut=6478*0.948228883;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=3 then povcut=6422*0.948228883;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=4 then povcut=6255*0.948228883;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=5 then povcut=6124*0.948228883;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1 GE 6 then povcut=5825*0.948228883;
end;

*Use 1969 Poverty Thresholds  (survey year 1970);
if &yr=1970 then do; 
if  hdsex=1 and hdage LE 64 and fpersons_final=1 then povcut=1975*1;
else if  hdsex=1  and hdage GE 65 and fpersons_final=1 then povcut=1774*1;
else if  hdsex=1  and hdage LE 64 and fpersons_final=2 and tot_kids_1=0 then povcut=2469*1;
else if  hdsex=1  and hdage LE 64 and fpersons_final=2 and tot_kids_1=1 then povcut=2766*1;
else if  hdsex=1  and hdage GE 65 and fpersons_final=2 and tot_kids_1=0 then povcut=2216*1;
else if  hdsex=1  and hdage GE 65 and fpersons_final=2 and tot_kids_1=1 then povcut=2766*1;
else if  hdsex=1  and fpersons_final=3 and tot_kids_1=0 then povcut=2875*1;
else if  hdsex=1  and fpersons_final=3 and tot_kids_1=1 then povcut=2968*1;
else if  hdsex=1  and fpersons_final=3 and tot_kids_1=2 then povcut=3137*1;
else if  hdsex=1  and fpersons_final=4 and tot_kids_1=0 then povcut=3790*1;
else if  hdsex=1  and fpersons_final=4 and tot_kids_1=1 then povcut=3847*1;
else if  hdsex=1  and fpersons_final=4 and tot_kids_1=2 then povcut=3715*1;
else if  hdsex=1  and fpersons_final=4 and tot_kids_1=3 then povcut=3902*1;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=0 then povcut=4574*1;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=1 then povcut=4630*1;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=2 then povcut=4481*1;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=3 then povcut=4368*1;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=4 then povcut=4462*1;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=0 then povcut=5247*1;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=1 then povcut=5265*1;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=2 then povcut=5153*1;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=3 then povcut=5041*1;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=4 then povcut=4891*1;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=5 then povcut=4967*1;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=0 then povcut=6609*1;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=1 then povcut=6665*1;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=2 then povcut=6535*1;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=3 then povcut=6422*1;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=4 then povcut=6274*1;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=5 then povcut=6049*1;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1 GE 6 then povcut=5994*1;


*Female non-farm;

else if  hdsex=2  and hdage LE 64 and fpersons_final=1 then povcut=1826*1;
else if  hdsex=2  and hdage GE 65 and fpersons_final=1 then povcut=1752*1;
else if  hdsex=2  and hdage LE 64 and fpersons_final=2 and tot_kids_1=0 then povcut=2282*1;
else if  hdsex=2  and hdage LE 64 and fpersons_final=2 and tot_kids_1=1 then povcut=2491*1;
else if  hdsex=2  and hdage GE 65 and fpersons_final=2 and tot_kids_1=0 then povcut=2190*1;
else if  hdsex=2  and hdage GE 65 and fpersons_final=2 and tot_kids_1=1 then povcut=2491*1;
else if  hdsex=2  and fpersons_final=3 and tot_kids_1=0 then povcut=2781*1;
else if  hdsex=2  and fpersons_final=3 and tot_kids_1=1 then povcut=2651*1;
else if  hdsex=2  and fpersons_final=3 and tot_kids_1=2 then povcut=2931*1;
else if  hdsex=2  and fpersons_final=4 and tot_kids_1=0 then povcut=3641*1;
else if  hdsex=2  and fpersons_final=4 and tot_kids_1=1 then povcut=3771*1;
else if  hdsex=2  and fpersons_final=4 and tot_kids_1=2 then povcut=3753*1;
else if  hdsex=2  and fpersons_final=4 and tot_kids_1=3 then povcut=3715*1;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=0 then povcut=4368*1;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=1 then povcut=4500*1;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=2 then povcut=4481*1;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=3 then povcut=4444*1;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=4 then povcut=4294*1;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=0 then povcut=5096*1;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=1 then povcut=5191*1;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=2 then povcut=5153*1;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=3 then povcut=5115*1;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=4 then povcut=4948*1;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=5 then povcut=4798*1;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=0 then povcut=6403*1;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=1 then povcut=6497*1;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=2 then povcut=6478*1;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=3 then povcut=6422*1;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=4 then povcut=6255*1;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=5 then povcut=6124*1;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1 GE 6 then povcut=5825*1;
end;

*Use 1969 Poverty Thresholds inflate using CPI-U to 1970 levels (survey year 1971);
if &yr=1971 then do;
if  hdsex=1 and hdage LE 64 and fpersons_final=1 then povcut=1975*1.057220708;
else if  hdsex=1  and hdage GE 65 and fpersons_final=1 then povcut=1774*1.057220708;
else if  hdsex=1  and hdage LE 64 and fpersons_final=2 and tot_kids_1=0 then povcut=2469*1.057220708;
else if  hdsex=1  and hdage LE 64 and fpersons_final=2 and tot_kids_1=1 then povcut=2766*1.057220708;
else if  hdsex=1  and hdage GE 65 and fpersons_final=2 and tot_kids_1=0 then povcut=2216*1.057220708;
else if  hdsex=1  and hdage GE 65 and fpersons_final=2 and tot_kids_1=1 then povcut=2766*1.057220708;
else if  hdsex=1  and fpersons_final=3 and tot_kids_1=0 then povcut=2875*1.057220708;
else if  hdsex=1  and fpersons_final=3 and tot_kids_1=1 then povcut=2968*1.057220708;
else if  hdsex=1  and fpersons_final=3 and tot_kids_1=2 then povcut=3137*1.057220708;
else if  hdsex=1  and fpersons_final=4 and tot_kids_1=0 then povcut=3790*1.057220708;
else if  hdsex=1  and fpersons_final=4 and tot_kids_1=1 then povcut=3847*1.057220708;
else if  hdsex=1  and fpersons_final=4 and tot_kids_1=2 then povcut=3715*1.057220708;
else if  hdsex=1  and fpersons_final=4 and tot_kids_1=3 then povcut=3902*1.057220708;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=0 then povcut=4574*1.057220708;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=1 then povcut=4630*1.057220708;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=2 then povcut=4481*1.057220708;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=3 then povcut=4368*1.057220708;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=4 then povcut=4462*1.057220708;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=0 then povcut=5247*1.057220708;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=1 then povcut=5265*1.057220708;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=2 then povcut=5153*1.057220708;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=3 then povcut=5041*1.057220708;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=4 then povcut=4891*1.057220708;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=5 then povcut=4967*1.057220708;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=0 then povcut=6609*1.057220708;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=1 then povcut=6665*1.057220708;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=2 then povcut=6535*1.057220708;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=3 then povcut=6422*1.057220708;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=4 then povcut=6274*1.057220708;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=5 then povcut=6049*1.057220708;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1 GE 6 then povcut=5994*1.057220708;


*Female non-farm;

else if  hdsex=2  and hdage LE 64 and fpersons_final=1 then povcut=1826*1.057220708;
else if  hdsex=2  and hdage GE 65 and fpersons_final=1 then povcut=1752*1.057220708;
else if  hdsex=2  and hdage LE 64 and fpersons_final=2 and tot_kids_1=0 then povcut=2282*1.057220708;
else if  hdsex=2  and hdage LE 64 and fpersons_final=2 and tot_kids_1=1 then povcut=2491*1.057220708;
else if  hdsex=2  and hdage GE 65 and fpersons_final=2 and tot_kids_1=0 then povcut=2190*1.057220708;
else if  hdsex=2  and hdage GE 65 and fpersons_final=2 and tot_kids_1=1 then povcut=2491*1.057220708;
else if  hdsex=2  and fpersons_final=3 and tot_kids_1=0 then povcut=2781*1.057220708;
else if  hdsex=2  and fpersons_final=3 and tot_kids_1=1 then povcut=2651*1.057220708;
else if  hdsex=2  and fpersons_final=3 and tot_kids_1=2 then povcut=2931*1.057220708;
else if  hdsex=2  and fpersons_final=4 and tot_kids_1=0 then povcut=3641*1.057220708;
else if  hdsex=2  and fpersons_final=4 and tot_kids_1=1 then povcut=3771*1.057220708;
else if  hdsex=2  and fpersons_final=4 and tot_kids_1=2 then povcut=3753*1.057220708;
else if  hdsex=2  and fpersons_final=4 and tot_kids_1=3 then povcut=3715*1.057220708;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=0 then povcut=4368*1.057220708;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=1 then povcut=4500*1.057220708;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=2 then povcut=4481*1.057220708;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=3 then povcut=4444*1.057220708;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=4 then povcut=4294*1.057220708;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=0 then povcut=5096*1.057220708;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=1 then povcut=5191*1.057220708;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=2 then povcut=5153*1.057220708;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=3 then povcut=5115*1.057220708;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=4 then povcut=4948*1.057220708;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=5 then povcut=4798*1.057220708;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=0 then povcut=6403*1.057220708;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=1 then povcut=6497*1.057220708;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=2 then povcut=6478*1.057220708;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=3 then povcut=6422*1.057220708;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=4 then povcut=6255*1.057220708;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=5 then povcut=6124*1.057220708;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1 GE 6 then povcut=5825*1.057220708;
end;
*Use 1969 Poverty Thresholds inflate using CPI-U to 1971 levels (survey year 1972);
if &yr=1972 then do;
if  hdsex=1 and hdage LE 64 and fpersons_final=1 then povcut=1975*1.103542234;
else if  hdsex=1  and hdage GE 65 and fpersons_final=1 then povcut=1774*1.103542234;
else if  hdsex=1  and hdage LE 64 and fpersons_final=2 and tot_kids_1=0 then povcut=2469*1.103542234;
else if  hdsex=1  and hdage LE 64 and fpersons_final=2 and tot_kids_1=1 then povcut=2766*1.103542234;
else if  hdsex=1  and hdage GE 65 and fpersons_final=2 and tot_kids_1=0 then povcut=2216*1.103542234;
else if  hdsex=1  and hdage GE 65 and fpersons_final=2 and tot_kids_1=1 then povcut=2766*1.103542234;
else if  hdsex=1  and fpersons_final=3 and tot_kids_1=0 then povcut=2875*1.103542234;
else if  hdsex=1  and fpersons_final=3 and tot_kids_1=1 then povcut=2968*1.103542234;
else if  hdsex=1  and fpersons_final=3 and tot_kids_1=2 then povcut=3137*1.103542234;
else if  hdsex=1  and fpersons_final=4 and tot_kids_1=0 then povcut=3790*1.103542234;
else if  hdsex=1  and fpersons_final=4 and tot_kids_1=1 then povcut=3847*1.103542234;
else if  hdsex=1  and fpersons_final=4 and tot_kids_1=2 then povcut=3715*1.103542234;
else if  hdsex=1  and fpersons_final=4 and tot_kids_1=3 then povcut=3902*1.103542234;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=0 then povcut=4574*1.103542234;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=1 then povcut=4630*1.103542234;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=2 then povcut=4481*1.103542234;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=3 then povcut=4368*1.103542234;
else if  hdsex=1  and fpersons_final=5 and tot_kids_1=4 then povcut=4462*1.103542234;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=0 then povcut=5247*1.103542234;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=1 then povcut=5265*1.103542234;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=2 then povcut=5153*1.103542234;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=3 then povcut=5041*1.103542234;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=4 then povcut=4891*1.103542234;
else if  hdsex=1  and fpersons_final=6 and tot_kids_1=5 then povcut=4967*1.103542234;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=0 then povcut=6609*1.103542234;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=1 then povcut=6665*1.103542234;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=2 then povcut=6535*1.103542234;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=3 then povcut=6422*1.103542234;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=4 then povcut=6274*1.103542234;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1=5 then povcut=6049*1.103542234;
else if  hdsex=1  and fpersons_final GE 7 and tot_kids_1 GE 6 then povcut=5994*1.103542234;


*Female non-farm;

else if  hdsex=2  and hdage LE 64 and fpersons_final=1 then povcut=1826*1.103542234;
else if  hdsex=2  and hdage GE 65 and fpersons_final=1 then povcut=1752*1.103542234;
else if  hdsex=2  and hdage LE 64 and fpersons_final=2 and tot_kids_1=0 then povcut=2282*1.103542234;
else if  hdsex=2  and hdage LE 64 and fpersons_final=2 and tot_kids_1=1 then povcut=2491*1.103542234;
else if  hdsex=2  and hdage GE 65 and fpersons_final=2 and tot_kids_1=0 then povcut=2190*1.103542234;
else if  hdsex=2  and hdage GE 65 and fpersons_final=2 and tot_kids_1=1 then povcut=2491*1.103542234;
else if  hdsex=2  and fpersons_final=3 and tot_kids_1=0 then povcut=2781*1.103542234;
else if  hdsex=2  and fpersons_final=3 and tot_kids_1=1 then povcut=2651*1.103542234;
else if  hdsex=2  and fpersons_final=3 and tot_kids_1=2 then povcut=2931*1.103542234;
else if  hdsex=2  and fpersons_final=4 and tot_kids_1=0 then povcut=3641*1.103542234;
else if  hdsex=2  and fpersons_final=4 and tot_kids_1=1 then povcut=3771*1.103542234;
else if  hdsex=2  and fpersons_final=4 and tot_kids_1=2 then povcut=3753*1.103542234;
else if  hdsex=2  and fpersons_final=4 and tot_kids_1=3 then povcut=3715*1.103542234;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=0 then povcut=4368*1.103542234;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=1 then povcut=4500*1.103542234;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=2 then povcut=4481*1.103542234;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=3 then povcut=4444*1.103542234;
else if  hdsex=2  and fpersons_final=5 and tot_kids_1=4 then povcut=4294*1.103542234;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=0 then povcut=5096*1.103542234;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=1 then povcut=5191*1.103542234;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=2 then povcut=5153*1.103542234;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=3 then povcut=5115*1.103542234;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=4 then povcut=4948*1.103542234;
else if  hdsex=2  and fpersons_final=6 and tot_kids_1=5 then povcut=4798*1.103542234;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=0 then povcut=6403*1.103542234;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=1 then povcut=6497*1.103542234;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=2 then povcut=6478*1.103542234;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=3 then povcut=6422*1.103542234;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=4 then povcut=6255*1.103542234;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1=5 then povcut=6124*1.103542234;
else if  hdsex=2  and fpersons_final GE 7 and tot_kids_1 GE 6 then povcut=5825*1.103542234;
end;
*Create an indicator for whether above or below poverty;
if ftotval_final-povcut GE 0 then poverty=0;
else if ftotval_final-povcut < 0 then poverty=1;
if ftotval_final-fpovcut_final GE 0 then poverty1=0;
else if ftotval_final-fpovcut_final < 0 then poverty1=1;
pov_diff=povcut-fpovcut_final;

if &yr IN(1968 1969 1971 1972) then msupwgt=msupwgt/100;
if &yr=1970 then msupwgt=msupwgt;
run;



%mend poverty6872;
%poverty6872(1968);
%poverty6872(1969);
%poverty6872(1970);
%poverty6872(1971);
*%poverty6872(1972);

*Derivation of Stats for Excel file Final Population and Poverty Results for CPS 1964-1972;

proc means sum data=cpsdata.poverty1972;
var msupwgt;
run;


proc means sum data=cpsdata.poverty1972;
var msupwgt;
where poverty=1;
run;

proc means sum data=cpsdata.poverty1972;
var msupwgt;
where poverty1=1;
run;
